   IPLR                 T
     G
  #pragma clang diagnostic ignored "-Wmissing-prototypes"

#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

// Implementation of the GLSL radians() function
template<typename T>
inline T radians(T d)
{
    return d * T(0.01745329251);
}

struct animated_mesh_gradient_fragment_main_out
{
    float4 fragColor [[color(0)]];
};

struct animated_mesh_gradient_fragment_main_in
{
    float2 _fragCoord [[user(locn0)]];
};

fragment animated_mesh_gradient_fragment_main_out animated_mesh_gradient_fragment_main(animated_mesh_gradient_fragment_main_in in [[stage_in]], constant float2& uSize [[buffer(0)]], constant float& uTime [[buffer(1)]], constant float& uFrequency [[buffer(2)]], constant float& uAmplitude [[buffer(3)]], constant float& uSpeed [[buffer(4)]], constant float& uGrain [[buffer(5)]], constant float3& uColor1 [[buffer(6)]], constant float3& uColor2 [[buffer(7)]], constant float3& uColor3 [[buffer(8)]], constant float3& uColor4 [[buffer(9)]])
{
    animated_mesh_gradient_fragment_main_out out = {};
    float2 _169 = in._fragCoord / uSize;
    float _176 = uSize.x / uSize.y;
    float2 _181 = _169 - float2(0.5);
    float _190 = _181.y;
    float2 _192 = float2(uTime * 0.100000001490116119384765625, _181.x * _190);
    float2 _332 = floor(_192);
    float2 _334 = fract(_192);
    float2 _342 = (_334 * _334) * (float2(3.0) - (_334 * 2.0));
    float2 _353 = _332 + float2(1.0, 0.0);
    float _362 = _342.x;
    float2 _365 = _332 + float2(0.0, 1.0);
    float2 _374 = _332 + float2(1.0);
    float2 _499 = _181;
    _499.y = _190 * (1.0 / _176);
    float _207 = radians((mix(mix(dot(float2(-1.0) + (fract(sin(float2(dot(_332, float2(2127.10009765625, 81.1699981689453125)), dot(_332, float2(1269.5, 283.3699951171875)))) * 43758.546875) * 2.0), _334), dot(float2(-1.0) + (fract(sin(float2(dot(_353, float2(2127.10009765625, 81.1699981689453125)), dot(_353, float2(1269.5, 283.3699951171875)))) * 43758.546875) * 2.0), _334 - float2(1.0, 0.0)), _362), mix(dot(float2(-1.0) + (fract(sin(float2(dot(_365, float2(2127.10009765625, 81.1699981689453125)), dot(_365, float2(1269.5, 283.3699951171875)))) * 43758.546875) * 2.0), _334 - float2(0.0, 1.0)), dot(float2(-1.0) + (fract(sin(float2(dot(_374, float2(2127.10009765625, 81.1699981689453125)), dot(_374, float2(1269.5, 283.3699951171875)))) * 43758.546875) * 2.0), _334 - float2(1.0)), _362), _342.y) * 360.0) + 180.0);
    float _441 = sin(_207);
    float _443 = cos(_207);
    float2 _211 = _499 * float2x2(float2(_443, -_441), float2(_441, _443));
    float _215 = _211.y * _176;
    float _227 = uTime * uSpeed;
    float _239 = _211.x + (sin((_215 * uFrequency) + _227) / uAmplitude);
    float2 _522 = float2(_239, _215);
    float _255 = _215 + (sin(((_239 * uFrequency) * 1.5) + _227) / (uAmplitude * 0.5));
    _522.y = _255;
    float3 _274 = float3(smoothstep(-0.300000011920928955078125, 0.20000000298023223876953125, (_522 * float2x2(float2(0.99619472026824951171875, 0.087155736982822418212890625), float2(-0.087155736982822418212890625, 0.99619472026824951171875))).x));
    float3 _296 = mix(mix(uColor1, uColor2, _274), mix(uColor3, uColor4, _274), float3(smoothstep(0.5, -0.300000011920928955078125, _255)));
    out.fragColor = float4(_296 + ((_296 * fract(sin(dot(_169 * (-1.0), float2(12.98980045318603515625, 78.233001708984375))) * 43758.546875)) * uGrain), 1.0);
    return out;
}

 
   0      l  0        |   @      2(   	                                    uColor4 j(                                       uColor3 (                                       uColor2 (                                       uColor1 (                                       uGrain  J(                                       uSpeed  
$                                
   uAmplitude  B$                                
   uFrequency  (                                       uTime  $                                               uSize   $   animated_mesh_gradient_fragment_main                  P     B  // This SkSL shader is autogenerated by spirv-cross.

float4 flutter_FragCoord;

uniform vec2 uSize;
uniform float uTime;
uniform float uFrequency;
uniform float uAmplitude;
uniform float uSpeed;
uniform float uGrain;
uniform vec3 uColor1;
uniform vec3 uColor2;
uniform vec3 uColor3;
uniform vec3 uColor4;

vec4 fragColor;

vec2 FLT_flutter_local_FlutterFragCoord()
{
    return flutter_FragCoord.xy;
}

vec2 FLT_flutter_local_hash(inout vec2 p)
{
    p = vec2(dot(p, vec2(2127.10009765625, 81.1699981689453125)), dot(p, vec2(1269.5, 283.3699951171875)));
    return fract(sin(p) * 43758.546875);
}

float FLT_flutter_local_noise(vec2 p)
{
    vec2 i = floor(p);
    vec2 f = fract(p);
    vec2 u = (f * f) * (vec2(3.0) - (f * 2.0));
    vec2 param = i + vec2(0.0);
    vec2 _97 = FLT_flutter_local_hash(param);
    vec2 param_1 = i + vec2(1.0, 0.0);
    vec2 _108 = FLT_flutter_local_hash(param_1);
    vec2 param_2 = i + vec2(0.0, 1.0);
    vec2 _124 = FLT_flutter_local_hash(param_2);
    vec2 param_3 = i + vec2(1.0);
    vec2 _135 = FLT_flutter_local_hash(param_3);
    float n = mix(mix(dot(vec2(-1.0) + (_97 * 2.0), f - vec2(0.0)), dot(vec2(-1.0) + (_108 * 2.0), f - vec2(1.0, 0.0)), u.x), mix(dot(vec2(-1.0) + (_124 * 2.0), f - vec2(0.0, 1.0)), dot(vec2(-1.0) + (_135 * 2.0), f - vec2(1.0)), u.x), u.y);
    return 0.5 + (0.5 * n);
}

mat2 FLT_flutter_local_Rot(float a)
{
    float s = sin(a);
    float c = cos(a);
    return mat2(vec2(c, -s), vec2(s, c));
}

float FLT_flutter_local_grainNoise(vec2 p)
{
    return fract(sin(dot(p * (-1.0), vec2(12.98980045318603515625, 78.233001708984375))) * 43758.546875);
}

void FLT_main()
{
    vec2 uv = FLT_flutter_local_FlutterFragCoord() / uSize;
    float ratio = uSize.x / uSize.y;
    vec2 tuv = uv;
    tuv -= vec2(0.5);
    vec2 param = vec2(uTime * 0.100000001490116119384765625, tuv.x * tuv.y);
    float degree = FLT_flutter_local_noise(param);
    tuv.y *= (1.0 / ratio);
    float param_1 = radians(((degree - 0.5) * 720.0) + 180.0);
    tuv *= FLT_flutter_local_Rot(param_1);
    tuv.y *= ratio;
    float frequency = uFrequency;
    float amplitude = uAmplitude;
    float speed = uTime * uSpeed;
    tuv.x += (sin((tuv.y * frequency) + speed) / amplitude);
    tuv.y += (sin(((tuv.x * frequency) * 1.5) + speed) / (amplitude * 0.5));
    float param_2 = -0.08726646006107330322265625;
    vec3 layer1 = mix(uColor1, uColor2, vec3(smoothstep(-0.300000011920928955078125, 0.20000000298023223876953125, (tuv * FLT_flutter_local_Rot(param_2)).x)));
    float param_3 = -0.08726646006107330322265625;
    vec3 layer2 = mix(uColor3, uColor4, vec3(smoothstep(-0.300000011920928955078125, 0.20000000298023223876953125, (tuv * FLT_flutter_local_Rot(param_3)).x)));
    vec3 finalComp = mix(layer1, layer2, vec3(smoothstep(0.5, -0.300000011920928955078125, tuv.y)));
    vec2 param_4 = uv;
    vec3 grainedComp = finalComp + ((finalComp * FLT_flutter_local_grainNoise(param_4)) * uGrain);
    vec3 col = grainedComp;
    fragColor = vec4(col, 1.0);
}

half4 main(float2 iFragCoord)
{
      flutter_FragCoord = float4(iFragCoord, 0, 0);
      FLT_main();
      return fragColor;
}
  
   X      |  0        |   @      *(   	                                    uColor4 b(                                       uColor3 (                                       uColor2 (                                       uColor1 
(                                       uGrain  $                                   uSpeed     (              $                                
   uAmplitude  (                                    
   uFrequency     ,              (                                       uTime                                             uSize   $   animated_mesh_gradient_fragment_main    